using System;
using System.Linq;

class Program
{
    static void Main()
    {
        var input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int W = int.Parse(input[1]);
        double epsilon = double.Parse(input[2]);

        var ponchos = new (int weight, int value)[N];
        for (int i = 0; i < N; i++)
        {
            var poncho = Console.ReadLine().Split().Select(int.Parse).ToArray();
            ponchos[i] = (poncho[0], poncho[1]);
        }

        var sortedPonchos = ponchos
            .Select((p, index) => new { Index = index + 1, Weight = p.weight, Value = p.value, Ratio = (double)p.value / p.weight })
            .OrderByDescending(p => p.Ratio)
            .ToList();

        int totalWeight = 0;
        int totalValue = 0;
        var selected = new System.Collections.Generic.List<int>();

        foreach (var poncho in sortedPonchos)
        {
            if (totalWeight + poncho.Weight <= W)
            {
                selected.Add(poncho.Index);
                totalWeight += poncho.Weight;
                totalValue += poncho.Value;
            }
        }

        Console.WriteLine(selected.Count);
        Console.WriteLine(string.Join(" ", selected));
    }
}

Srecko i poncoi 20